<?php $__env->startSection('title', __('report.customer') . ' - ' . __('report.supplier') . ' ' . __('report.reports')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1><?php echo e(__('report.customer')); ?> & <?php echo e(__('report.supplier')); ?> <?php echo e(__('report.reports')); ?></h1>
    <!-- <ol class="breadcrumb">
        <li><a href="#"><i class="fa fa-dashboard"></i> Level</a></li>
        <li class="active">Here</li>
    </ol> -->
</section>

<!-- Main content -->
<section class="content">
    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
    <div class="table-responsive">
        <table class="table table-bordered table-striped" id="supplier_report_tbl">
            <thead>
                <tr>
                    <th><?php echo e(app('translator')->getFromJson('report.contact')); ?></th>
                    <th><?php echo e(app('translator')->getFromJson('report.total_purchase')); ?></th>
                    <th><?php echo e(app('translator')->getFromJson('lang_v1.total_purchase_return')); ?></th>
                    <th><?php echo e(app('translator')->getFromJson('report.total_sell')); ?></th>
                    <th><?php echo e(app('translator')->getFromJson('lang_v1.total_sell_return')); ?></th>
                    <th><?php echo e(app('translator')->getFromJson('lang_v1.opening_balance_due')); ?></th>
                    <th><?php echo e(app('translator')->getFromJson('report.total_due')); ?> &nbsp;&nbsp;<i class="fa fa-info-circle text-info no-print" data-toggle="tooltip" data-placement="bottom" data-html="true" data-original-title="<?php echo e(__('messages.due_tooltip')); ?>" aria-hidden="true"></i></th>
                </tr>
            </thead>
            <tfoot>
                <tr class="bg-gray font-17 footer-total text-center">
                    <td><strong><?php echo e(app('translator')->getFromJson('sale.total')); ?>:</strong></td>
                    <td><span class="display_currency" id="footer_total_purchase" data-currency_symbol ="true"></span></td>
                    <td><span class="display_currency" id="footer_total_purchase_return" data-currency_symbol ="true"></span></td>
                    <td><span class="display_currency" id="footer_total_sell" data-currency_symbol ="true"></span></td>
                    <td><span class="display_currency" id="footer_total_sell_return" data-currency_symbol ="true"></span></td>
                    <td><span class="display_currency" id="footer_total_opening_bal_due" data-currency_symbol ="true"></span></td>
                    <td><span class="display_currency" id="footer_total_due" data-currency_symbol ="true"></span></td>
                </tr>
            </tfoot>
        </table>
    </div>
    <?php echo $__env->renderComponent(); ?>
</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v)); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>